// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> Action to be taken when the operation fails for a object. </summary>
    public readonly partial struct OnFailureAction : IEquatable<OnFailureAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OnFailureAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OnFailureAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BreakValue = "break";

        /// <summary> break. </summary>
        public static OnFailureAction Break { get; } = new OnFailureAction(BreakValue);
        /// <summary> Determines if two <see cref="OnFailureAction"/> values are the same. </summary>
        public static bool operator ==(OnFailureAction left, OnFailureAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OnFailureAction"/> values are not the same. </summary>
        public static bool operator !=(OnFailureAction left, OnFailureAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OnFailureAction"/>. </summary>
        public static implicit operator OnFailureAction(string value) => new OnFailureAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OnFailureAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OnFailureAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
