// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> Represents the condition block name that matched blob properties. </summary>
    public readonly partial struct MatchedBlockName : IEquatable<MatchedBlockName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MatchedBlockName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MatchedBlockName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IfValue = "If";
        private const string ElseValue = "Else";
        private const string NoneValue = "None";

        /// <summary> If. </summary>
        public static MatchedBlockName If { get; } = new MatchedBlockName(IfValue);
        /// <summary> Else. </summary>
        public static MatchedBlockName Else { get; } = new MatchedBlockName(ElseValue);
        /// <summary> None. </summary>
        public static MatchedBlockName None { get; } = new MatchedBlockName(NoneValue);
        /// <summary> Determines if two <see cref="MatchedBlockName"/> values are the same. </summary>
        public static bool operator ==(MatchedBlockName left, MatchedBlockName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MatchedBlockName"/> values are not the same. </summary>
        public static bool operator !=(MatchedBlockName left, MatchedBlockName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MatchedBlockName"/>. </summary>
        public static implicit operator MatchedBlockName(string value) => new MatchedBlockName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MatchedBlockName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MatchedBlockName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
