// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Storage.Queues.Models
{
    /// <summary> a summary of request statistics grouped by API in hour or minute aggregates for queues. </summary>
    public partial class QueueMetrics
    {
        /// <summary> Initializes a new instance of <see cref="QueueMetrics"/>. </summary>
        /// <param name="version"> The version of Storage Analytics to configure. </param>
        /// <param name="enabled"> Indicates whether metrics are enabled for the Queue service. </param>
        /// <param name="includeApis"> Indicates whether metrics should generate summary statistics for called API operations. </param>
        /// <param name="retentionPolicy"> the retention policy. </param>
        internal QueueMetrics(string version, bool enabled, bool? includeApis, QueueRetentionPolicy retentionPolicy)
        {
            Version = version;
            Enabled = enabled;
            IncludeApis = includeApis;
            RetentionPolicy = retentionPolicy;
        }

        /// <summary> The version of Storage Analytics to configure. </summary>
        public string Version { get; set; }
        /// <summary> Indicates whether metrics are enabled for the Queue service. </summary>
        public bool Enabled { get; set; }
        /// <summary> the retention policy. </summary>
        public QueueRetentionPolicy RetentionPolicy { get; set; }
    }
}
