// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Queues.Models
{
    internal static partial class QueueGeoReplicationStatusExtensions
    {
        public static string ToSerialString(this QueueGeoReplicationStatus value) => value switch
        {
            QueueGeoReplicationStatus.Live => "live",
            QueueGeoReplicationStatus.Bootstrap => "bootstrap",
            QueueGeoReplicationStatus.Unavailable => "unavailable",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueueGeoReplicationStatus value.")
        };

        public static QueueGeoReplicationStatus ToQueueGeoReplicationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "live")) return QueueGeoReplicationStatus.Live;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "bootstrap")) return QueueGeoReplicationStatus.Bootstrap;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "unavailable")) return QueueGeoReplicationStatus.Unavailable;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueueGeoReplicationStatus value.");
        }
    }
}
