// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Storage.Queues
{
    internal partial class MessageIdUpdateHeaders
    {
        private readonly Response _response;
        public MessageIdUpdateHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicates the version of the Queue service used to execute the request. This header is returned for requests made against version 2009-09-19 and above. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> The pop receipt of the queue message. </summary>
        public string PopReceipt => _response.Headers.TryGetValue("x-ms-popreceipt", out string value) ? value : null;
        /// <summary> A UTC date/time value that represents when the message will be visible on the queue. </summary>
        public DateTimeOffset? TimeNextVisible => _response.Headers.TryGetValue("x-ms-time-next-visible", out DateTimeOffset? value) ? value : null;
    }
}
