// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using System.Xml.Linq;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Storage.Common;
using Azure.Storage.Files.Shares.Models;

namespace Azure.Storage.Files.Shares
{
    internal partial class ShareRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _url;
        private readonly string _version;
        private readonly ShareTokenIntent? _fileRequestIntent;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of ShareRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="url"> The URL of the service account, share, directory or file that is the target of the desired operation. </param>
        /// <param name="version"> Specifies the version of the operation to use for this request. The default value is "2025-01-05". </param>
        /// <param name="fileRequestIntent"> Valid value is backup. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="url"/> or <paramref name="version"/> is null. </exception>
        public ShareRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string url, string version, ShareTokenIntent? fileRequestIntent = null)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _url = url ?? throw new ArgumentNullException(nameof(url));
            _version = version ?? throw new ArgumentNullException(nameof(version));
            _fileRequestIntent = fileRequestIntent;
        }

        internal HttpMessage CreateCreateRequest(int? timeout, IDictionary<string, string> metadata, int? quota, ShareAccessTier? accessTier, string enabledProtocols, ShareRootSquash? rootSquash, bool? enableSnapshotVirtualDirectoryAccess, bool? paidBurstingEnabled, long? paidBurstingMaxBandwidthMibps, long? paidBurstingMaxIops, long? shareProvisionedIops, long? shareProvisionedBandwidthMibps)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            if (metadata != null)
            {
                request.Headers.Add("x-ms-meta-", metadata);
            }
            if (quota != null)
            {
                request.Headers.Add("x-ms-share-quota", quota.Value);
            }
            if (accessTier != null)
            {
                request.Headers.Add("x-ms-access-tier", accessTier.Value.ToString());
            }
            request.Headers.Add("x-ms-version", _version);
            if (enabledProtocols != null)
            {
                request.Headers.Add("x-ms-enabled-protocols", enabledProtocols);
            }
            if (rootSquash != null)
            {
                request.Headers.Add("x-ms-root-squash", rootSquash.Value.ToSerialString());
            }
            if (enableSnapshotVirtualDirectoryAccess != null)
            {
                request.Headers.Add("x-ms-enable-snapshot-virtual-directory-access", enableSnapshotVirtualDirectoryAccess.Value);
            }
            if (paidBurstingEnabled != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-enabled", paidBurstingEnabled.Value);
            }
            if (paidBurstingMaxBandwidthMibps != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-max-bandwidth-mibps", paidBurstingMaxBandwidthMibps.Value);
            }
            if (paidBurstingMaxIops != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-max-iops", paidBurstingMaxIops.Value);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            if (shareProvisionedIops != null)
            {
                request.Headers.Add("x-ms-share-provisioned-iops", shareProvisionedIops.Value);
            }
            if (shareProvisionedBandwidthMibps != null)
            {
                request.Headers.Add("x-ms-share-provisioned-bandwidth-mibps", shareProvisionedBandwidthMibps.Value);
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Creates a new share under the specified account. If the share with the same name already exists, the operation fails. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="quota"> Specifies the maximum size of the share, in gigabytes. </param>
        /// <param name="accessTier"> Specifies the access tier of the share. </param>
        /// <param name="enabledProtocols"> Protocols to enable on the share. </param>
        /// <param name="rootSquash"> Root squash to set on the share.  Only valid for NFS shares. </param>
        /// <param name="enableSnapshotVirtualDirectoryAccess"> The <see cref="bool"/>? to use. </param>
        /// <param name="paidBurstingEnabled"> Optional. Boolean. Default if not specified is false. This property enables paid bursting. </param>
        /// <param name="paidBurstingMaxBandwidthMibps"> Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a file share is 10,340  MiB/sec. </param>
        /// <param name="paidBurstingMaxIops"> Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file share is 102,400 IOPS. </param>
        /// <param name="shareProvisionedIops"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is set to value calculated based on recommendation formula. </param>
        /// <param name="shareProvisionedBandwidthMibps"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareCreateHeaders>> CreateAsync(int? timeout = null, IDictionary<string, string> metadata = null, int? quota = null, ShareAccessTier? accessTier = null, string enabledProtocols = null, ShareRootSquash? rootSquash = null, bool? enableSnapshotVirtualDirectoryAccess = null, bool? paidBurstingEnabled = null, long? paidBurstingMaxBandwidthMibps = null, long? paidBurstingMaxIops = null, long? shareProvisionedIops = null, long? shareProvisionedBandwidthMibps = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCreateRequest(timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareCreateHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a new share under the specified account. If the share with the same name already exists, the operation fails. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="quota"> Specifies the maximum size of the share, in gigabytes. </param>
        /// <param name="accessTier"> Specifies the access tier of the share. </param>
        /// <param name="enabledProtocols"> Protocols to enable on the share. </param>
        /// <param name="rootSquash"> Root squash to set on the share.  Only valid for NFS shares. </param>
        /// <param name="enableSnapshotVirtualDirectoryAccess"> The <see cref="bool"/>? to use. </param>
        /// <param name="paidBurstingEnabled"> Optional. Boolean. Default if not specified is false. This property enables paid bursting. </param>
        /// <param name="paidBurstingMaxBandwidthMibps"> Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a file share is 10,340  MiB/sec. </param>
        /// <param name="paidBurstingMaxIops"> Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file share is 102,400 IOPS. </param>
        /// <param name="shareProvisionedIops"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is set to value calculated based on recommendation formula. </param>
        /// <param name="shareProvisionedBandwidthMibps"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareCreateHeaders> Create(int? timeout = null, IDictionary<string, string> metadata = null, int? quota = null, ShareAccessTier? accessTier = null, string enabledProtocols = null, ShareRootSquash? rootSquash = null, bool? enableSnapshotVirtualDirectoryAccess = null, bool? paidBurstingEnabled = null, long? paidBurstingMaxBandwidthMibps = null, long? paidBurstingMaxIops = null, long? shareProvisionedIops = null, long? shareProvisionedBandwidthMibps = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCreateRequest(timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareCreateHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetPropertiesRequest(string sharesnapshot, int? timeout, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Returns all user-defined metadata and system properties for the specified share or share snapshot. The data returned does not include the share's list of files. </summary>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareGetPropertiesHeaders>> GetPropertiesAsync(string sharesnapshot = null, int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetPropertiesRequest(sharesnapshot, timeout, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareGetPropertiesHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns all user-defined metadata and system properties for the specified share or share snapshot. The data returned does not include the share's list of files. </summary>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareGetPropertiesHeaders> GetProperties(string sharesnapshot = null, int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetPropertiesRequest(sharesnapshot, timeout, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareGetPropertiesHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteRequest(string sharesnapshot, int? timeout, DeleteSnapshotsOptionType? deleteSnapshots, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (deleteSnapshots != null)
            {
                request.Headers.Add("x-ms-delete-snapshots", deleteSnapshots.Value.ToSerialString());
            }
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files contained within it are later deleted during garbage collection. </summary>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="deleteSnapshots"> Specifies the option include to delete the base share and all of its snapshots. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareDeleteHeaders>> DeleteAsync(string sharesnapshot = null, int? timeout = null, DeleteSnapshotsOptionType? deleteSnapshots = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteRequest(sharesnapshot, timeout, deleteSnapshots, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareDeleteHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Operation marks the specified share or share snapshot for deletion. The share or share snapshot and any files contained within it are later deleted during garbage collection. </summary>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="deleteSnapshots"> Specifies the option include to delete the base share and all of its snapshots. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareDeleteHeaders> Delete(string sharesnapshot = null, int? timeout = null, DeleteSnapshotsOptionType? deleteSnapshots = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteRequest(sharesnapshot, timeout, deleteSnapshots, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareDeleteHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAcquireLeaseRequest(int? timeout, int? duration, string proposedLeaseId, string sharesnapshot)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("comp", "lease", true);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-lease-action", "acquire");
            if (duration != null)
            {
                request.Headers.Add("x-ms-lease-duration", duration.Value);
            }
            if (proposedLeaseId != null)
            {
                request.Headers.Add("x-ms-proposed-lease-id", proposedLeaseId);
            }
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="duration"> Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or change. </param>
        /// <param name="proposedLeaseId"> Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareAcquireLeaseHeaders>> AcquireLeaseAsync(int? timeout = null, int? duration = null, string proposedLeaseId = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAcquireLeaseRequest(timeout, duration, proposedLeaseId, sharesnapshot);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareAcquireLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="duration"> Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or change. </param>
        /// <param name="proposedLeaseId"> Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareAcquireLeaseHeaders> AcquireLease(int? timeout = null, int? duration = null, string proposedLeaseId = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateAcquireLeaseRequest(timeout, duration, proposedLeaseId, sharesnapshot);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareAcquireLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateReleaseLeaseRequest(string leaseId, int? timeout, string sharesnapshot)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("comp", "lease", true);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-lease-action", "release");
            request.Headers.Add("x-ms-lease-id", leaseId);
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public async Task<ResponseWithHeaders<ShareReleaseLeaseHeaders>> ReleaseLeaseAsync(string leaseId, int? timeout = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateReleaseLeaseRequest(leaseId, timeout, sharesnapshot);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareReleaseLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public ResponseWithHeaders<ShareReleaseLeaseHeaders> ReleaseLease(string leaseId, int? timeout = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateReleaseLeaseRequest(leaseId, timeout, sharesnapshot);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareReleaseLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateChangeLeaseRequest(string leaseId, int? timeout, string proposedLeaseId, string sharesnapshot)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("comp", "lease", true);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-lease-action", "change");
            request.Headers.Add("x-ms-lease-id", leaseId);
            if (proposedLeaseId != null)
            {
                request.Headers.Add("x-ms-proposed-lease-id", proposedLeaseId);
            }
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="proposedLeaseId"> Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public async Task<ResponseWithHeaders<ShareChangeLeaseHeaders>> ChangeLeaseAsync(string leaseId, int? timeout = null, string proposedLeaseId = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateChangeLeaseRequest(leaseId, timeout, proposedLeaseId, sharesnapshot);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareChangeLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="proposedLeaseId"> Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID string formats. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public ResponseWithHeaders<ShareChangeLeaseHeaders> ChangeLease(string leaseId, int? timeout = null, string proposedLeaseId = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateChangeLeaseRequest(leaseId, timeout, proposedLeaseId, sharesnapshot);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareChangeLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRenewLeaseRequest(string leaseId, int? timeout, string sharesnapshot)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("comp", "lease", true);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-lease-action", "renew");
            request.Headers.Add("x-ms-lease-id", leaseId);
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public async Task<ResponseWithHeaders<ShareRenewLeaseHeaders>> RenewLeaseAsync(string leaseId, int? timeout = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateRenewLeaseRequest(leaseId, timeout, sharesnapshot);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareRenewLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="leaseId"> Specifies the current lease ID on the resource. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="leaseId"/> is null. </exception>
        public ResponseWithHeaders<ShareRenewLeaseHeaders> RenewLease(string leaseId, int? timeout = null, string sharesnapshot = null, CancellationToken cancellationToken = default)
        {
            if (leaseId == null)
            {
                throw new ArgumentNullException(nameof(leaseId));
            }

            using var message = CreateRenewLeaseRequest(leaseId, timeout, sharesnapshot);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareRenewLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateBreakLeaseRequest(int? timeout, int? breakPeriod, string sharesnapshot, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("comp", "lease", true);
            uri.AppendQuery("restype", "share", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            if (sharesnapshot != null)
            {
                uri.AppendQuery("sharesnapshot", sharesnapshot, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-lease-action", "break");
            if (breakPeriod != null)
            {
                request.Headers.Add("x-ms-lease-break-period", breakPeriod.Value);
            }
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="breakPeriod"> For a break operation, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease. If longer, the time remaining on the lease is used. A new lease will not be available before the break period has expired, but the lease may be held for longer than the break period. If this header does not appear with a break operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks immediately. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareBreakLeaseHeaders>> BreakLeaseAsync(int? timeout = null, int? breakPeriod = null, string sharesnapshot = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateBreakLeaseRequest(timeout, breakPeriod, sharesnapshot, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareBreakLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> The Lease Share operation establishes and manages a lock on a share, or the specified snapshot for set and delete share operations. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="breakPeriod"> For a break operation, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease. If longer, the time remaining on the lease is used. A new lease will not be available before the break period has expired, but the lease may be held for longer than the break period. If this header does not appear with a break operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks immediately. </param>
        /// <param name="sharesnapshot"> The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareBreakLeaseHeaders> BreakLease(int? timeout = null, int? breakPeriod = null, string sharesnapshot = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateBreakLeaseRequest(timeout, breakPeriod, sharesnapshot, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareBreakLeaseHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateSnapshotRequest(int? timeout, IDictionary<string, string> metadata)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "snapshot", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            if (metadata != null)
            {
                request.Headers.Add("x-ms-meta-", metadata);
            }
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Creates a read-only snapshot of a share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareCreateSnapshotHeaders>> CreateSnapshotAsync(int? timeout = null, IDictionary<string, string> metadata = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCreateSnapshotRequest(timeout, metadata);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareCreateSnapshotHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a read-only snapshot of a share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareCreateSnapshotHeaders> CreateSnapshot(int? timeout = null, IDictionary<string, string> metadata = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCreateSnapshotRequest(timeout, metadata);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareCreateSnapshotHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreatePermissionRequest(SharePermission sharePermission, int? timeout)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "filepermission", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(sharePermission);
            request.Content = content;
            return message;
        }

        /// <summary> Create a permission (a security descriptor). </summary>
        /// <param name="sharePermission"> A permission (a security descriptor) at the share level. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sharePermission"/> is null. </exception>
        public async Task<ResponseWithHeaders<ShareCreatePermissionHeaders>> CreatePermissionAsync(SharePermission sharePermission, int? timeout = null, CancellationToken cancellationToken = default)
        {
            if (sharePermission == null)
            {
                throw new ArgumentNullException(nameof(sharePermission));
            }

            using var message = CreateCreatePermissionRequest(sharePermission, timeout);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareCreatePermissionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a permission (a security descriptor). </summary>
        /// <param name="sharePermission"> A permission (a security descriptor) at the share level. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sharePermission"/> is null. </exception>
        public ResponseWithHeaders<ShareCreatePermissionHeaders> CreatePermission(SharePermission sharePermission, int? timeout = null, CancellationToken cancellationToken = default)
        {
            if (sharePermission == null)
            {
                throw new ArgumentNullException(nameof(sharePermission));
            }

            using var message = CreateCreatePermissionRequest(sharePermission, timeout);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareCreatePermissionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetPermissionRequest(string filePermissionKey, FilePermissionFormat? filePermissionFormat, int? timeout)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "filepermission", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-file-permission-key", filePermissionKey);
            if (filePermissionFormat != null)
            {
                request.Headers.Add("x-ms-file-permission-format", filePermissionFormat.Value.ToSerialString());
            }
            request.Headers.Add("x-ms-version", _version);
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Returns the permission (security descriptor) for a given key. </summary>
        /// <param name="filePermissionKey"> Key of the permission to be set for the directory/file. </param>
        /// <param name="filePermissionFormat"> Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the permission. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filePermissionKey"/> is null. </exception>
        public async Task<ResponseWithHeaders<SharePermission, ShareGetPermissionHeaders>> GetPermissionAsync(string filePermissionKey, FilePermissionFormat? filePermissionFormat = null, int? timeout = null, CancellationToken cancellationToken = default)
        {
            if (filePermissionKey == null)
            {
                throw new ArgumentNullException(nameof(filePermissionKey));
            }

            using var message = CreateGetPermissionRequest(filePermissionKey, filePermissionFormat, timeout);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareGetPermissionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SharePermission value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SharePermission.DeserializeSharePermission(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns the permission (security descriptor) for a given key. </summary>
        /// <param name="filePermissionKey"> Key of the permission to be set for the directory/file. </param>
        /// <param name="filePermissionFormat"> Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable values are SDDL or binary. If x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the permission is returned as a base64 string representing the binary encoding of the permission. </param>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filePermissionKey"/> is null. </exception>
        public ResponseWithHeaders<SharePermission, ShareGetPermissionHeaders> GetPermission(string filePermissionKey, FilePermissionFormat? filePermissionFormat = null, int? timeout = null, CancellationToken cancellationToken = default)
        {
            if (filePermissionKey == null)
            {
                throw new ArgumentNullException(nameof(filePermissionKey));
            }

            using var message = CreateGetPermissionRequest(filePermissionKey, filePermissionFormat, timeout);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareGetPermissionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SharePermission value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SharePermission.DeserializeSharePermission(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSetPropertiesRequest(int? timeout, int? quota, ShareAccessTier? accessTier, ShareRootSquash? rootSquash, bool? enableSnapshotVirtualDirectoryAccess, bool? paidBurstingEnabled, long? paidBurstingMaxBandwidthMibps, long? paidBurstingMaxIops, long? shareProvisionedIops, long? shareProvisionedBandwidthMibps, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "properties", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (quota != null)
            {
                request.Headers.Add("x-ms-share-quota", quota.Value);
            }
            if (accessTier != null)
            {
                request.Headers.Add("x-ms-access-tier", accessTier.Value.ToString());
            }
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (rootSquash != null)
            {
                request.Headers.Add("x-ms-root-squash", rootSquash.Value.ToSerialString());
            }
            if (enableSnapshotVirtualDirectoryAccess != null)
            {
                request.Headers.Add("x-ms-enable-snapshot-virtual-directory-access", enableSnapshotVirtualDirectoryAccess.Value);
            }
            if (paidBurstingEnabled != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-enabled", paidBurstingEnabled.Value);
            }
            if (paidBurstingMaxBandwidthMibps != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-max-bandwidth-mibps", paidBurstingMaxBandwidthMibps.Value);
            }
            if (paidBurstingMaxIops != null)
            {
                request.Headers.Add("x-ms-share-paid-bursting-max-iops", paidBurstingMaxIops.Value);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            if (shareProvisionedIops != null)
            {
                request.Headers.Add("x-ms-share-provisioned-iops", shareProvisionedIops.Value);
            }
            if (shareProvisionedBandwidthMibps != null)
            {
                request.Headers.Add("x-ms-share-provisioned-bandwidth-mibps", shareProvisionedBandwidthMibps.Value);
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Sets properties for the specified share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="quota"> Specifies the maximum size of the share, in gigabytes. </param>
        /// <param name="accessTier"> Specifies the access tier of the share. </param>
        /// <param name="rootSquash"> Root squash to set on the share.  Only valid for NFS shares. </param>
        /// <param name="enableSnapshotVirtualDirectoryAccess"> The <see cref="bool"/>? to use. </param>
        /// <param name="paidBurstingEnabled"> Optional. Boolean. Default if not specified is false. This property enables paid bursting. </param>
        /// <param name="paidBurstingMaxBandwidthMibps"> Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a file share is 10,340  MiB/sec. </param>
        /// <param name="paidBurstingMaxIops"> Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file share is 102,400 IOPS. </param>
        /// <param name="shareProvisionedIops"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is set to value calculated based on recommendation formula. </param>
        /// <param name="shareProvisionedBandwidthMibps"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareSetPropertiesHeaders>> SetPropertiesAsync(int? timeout = null, int? quota = null, ShareAccessTier? accessTier = null, ShareRootSquash? rootSquash = null, bool? enableSnapshotVirtualDirectoryAccess = null, bool? paidBurstingEnabled = null, long? paidBurstingMaxBandwidthMibps = null, long? paidBurstingMaxIops = null, long? shareProvisionedIops = null, long? shareProvisionedBandwidthMibps = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetPropertiesRequest(timeout, quota, accessTier, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareSetPropertiesHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Sets properties for the specified share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="quota"> Specifies the maximum size of the share, in gigabytes. </param>
        /// <param name="accessTier"> Specifies the access tier of the share. </param>
        /// <param name="rootSquash"> Root squash to set on the share.  Only valid for NFS shares. </param>
        /// <param name="enableSnapshotVirtualDirectoryAccess"> The <see cref="bool"/>? to use. </param>
        /// <param name="paidBurstingEnabled"> Optional. Boolean. Default if not specified is false. This property enables paid bursting. </param>
        /// <param name="paidBurstingMaxBandwidthMibps"> Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a file share is 10,340  MiB/sec. </param>
        /// <param name="paidBurstingMaxIops"> Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file share is 102,400 IOPS. </param>
        /// <param name="shareProvisionedIops"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned number of input/output operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is set to value calculated based on recommendation formula. </param>
        /// <param name="shareProvisionedBandwidthMibps"> Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share, in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to value calculated based on recommendation formula. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareSetPropertiesHeaders> SetProperties(int? timeout = null, int? quota = null, ShareAccessTier? accessTier = null, ShareRootSquash? rootSquash = null, bool? enableSnapshotVirtualDirectoryAccess = null, bool? paidBurstingEnabled = null, long? paidBurstingMaxBandwidthMibps = null, long? paidBurstingMaxIops = null, long? shareProvisionedIops = null, long? shareProvisionedBandwidthMibps = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetPropertiesRequest(timeout, quota, accessTier, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareSetPropertiesHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSetMetadataRequest(int? timeout, IDictionary<string, string> metadata, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "metadata", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            if (metadata != null)
            {
                request.Headers.Add("x-ms-meta-", metadata);
            }
            request.Headers.Add("x-ms-version", _version);
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Sets one or more user-defined name-value pairs for the specified share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareSetMetadataHeaders>> SetMetadataAsync(int? timeout = null, IDictionary<string, string> metadata = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetMetadataRequest(timeout, metadata, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareSetMetadataHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Sets one or more user-defined name-value pairs for the specified share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="metadata"> A name-value pair to associate with a file storage object. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareSetMetadataHeaders> SetMetadata(int? timeout = null, IDictionary<string, string> metadata = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetMetadataRequest(timeout, metadata, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareSetMetadataHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetAccessPolicyRequest(int? timeout, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "acl", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Returns information about stored access policies specified on the share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<IReadOnlyList<ShareSignedIdentifier>, ShareGetAccessPolicyHeaders>> GetAccessPolicyAsync(int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAccessPolicyRequest(timeout, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareGetAccessPolicyHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<ShareSignedIdentifier> value = default;
                        var document = XDocument.Load(message.Response.ContentStream, LoadOptions.PreserveWhitespace);
                        if (document.Element("SignedIdentifiers") is XElement signedIdentifiersElement)
                        {
                            var array = new List<ShareSignedIdentifier>();
                            foreach (var e in signedIdentifiersElement.Elements("SignedIdentifier"))
                            {
                                array.Add(ShareSignedIdentifier.DeserializeShareSignedIdentifier(e));
                            }
                            value = array;
                        }
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns information about stored access policies specified on the share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<IReadOnlyList<ShareSignedIdentifier>, ShareGetAccessPolicyHeaders> GetAccessPolicy(int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetAccessPolicyRequest(timeout, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareGetAccessPolicyHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<ShareSignedIdentifier> value = default;
                        var document = XDocument.Load(message.Response.ContentStream, LoadOptions.PreserveWhitespace);
                        if (document.Element("SignedIdentifiers") is XElement signedIdentifiersElement)
                        {
                            var array = new List<ShareSignedIdentifier>();
                            foreach (var e in signedIdentifiersElement.Elements("SignedIdentifier"))
                            {
                                array.Add(ShareSignedIdentifier.DeserializeShareSignedIdentifier(e));
                            }
                            value = array;
                        }
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSetAccessPolicyRequest(int? timeout, IEnumerable<ShareSignedIdentifier> shareAcl, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "acl", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            if (shareAcl != null)
            {
                request.Headers.Add("Content-Type", "application/xml");
                var content = new XmlWriterContent();
                content.XmlWriter.WriteStartElement("SignedIdentifiers");
                foreach (var item in shareAcl)
                {
                    content.XmlWriter.WriteObjectValue(item, "SignedIdentifier");
                }
                content.XmlWriter.WriteEndElement();
                request.Content = content;
            }
            return message;
        }

        /// <summary> Sets a stored access policy for use with shared access signatures. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareAcl"> The ACL for the share. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareSetAccessPolicyHeaders>> SetAccessPolicyAsync(int? timeout = null, IEnumerable<ShareSignedIdentifier> shareAcl = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetAccessPolicyRequest(timeout, shareAcl, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareSetAccessPolicyHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Sets a stored access policy for use with shared access signatures. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareAcl"> The ACL for the share. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareSetAccessPolicyHeaders> SetAccessPolicy(int? timeout = null, IEnumerable<ShareSignedIdentifier> shareAcl = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateSetAccessPolicyRequest(timeout, shareAcl, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareSetAccessPolicyHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetStatisticsRequest(int? timeout, ShareFileRequestConditions shareFileRequestConditions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "stats", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (shareFileRequestConditions?.LeaseId != null)
            {
                request.Headers.Add("x-ms-lease-id", shareFileRequestConditions.LeaseId);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Retrieves statistics related to the share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareStatistics, ShareGetStatisticsHeaders>> GetStatisticsAsync(int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetStatisticsRequest(timeout, shareFileRequestConditions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareGetStatisticsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ShareStatistics value = default;
                        var document = XDocument.Load(message.Response.ContentStream, LoadOptions.PreserveWhitespace);
                        if (document.Element("ShareStats") is XElement shareStatsElement)
                        {
                            value = ShareStatistics.DeserializeShareStatistics(shareStatsElement);
                        }
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Retrieves statistics related to the share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="shareFileRequestConditions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareStatistics, ShareGetStatisticsHeaders> GetStatistics(int? timeout = null, ShareFileRequestConditions shareFileRequestConditions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetStatisticsRequest(timeout, shareFileRequestConditions);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareGetStatisticsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ShareStatistics value = default;
                        var document = XDocument.Load(message.Response.ContentStream, LoadOptions.PreserveWhitespace);
                        if (document.Element("ShareStats") is XElement shareStatsElement)
                        {
                            value = ShareStatistics.DeserializeShareStatistics(shareStatsElement);
                        }
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRestoreRequest(int? timeout, string deletedShareName, string deletedShareVersion)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_url, false);
            uri.AppendQuery("restype", "share", true);
            uri.AppendQuery("comp", "undelete", true);
            if (timeout != null)
            {
                uri.AppendQuery("timeout", timeout.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("x-ms-version", _version);
            if (deletedShareName != null)
            {
                request.Headers.Add("x-ms-deleted-share-name", deletedShareName);
            }
            if (deletedShareVersion != null)
            {
                request.Headers.Add("x-ms-deleted-share-version", deletedShareVersion);
            }
            if (_fileRequestIntent != null)
            {
                request.Headers.Add("x-ms-file-request-intent", _fileRequestIntent.Value.ToString());
            }
            request.Headers.Add("Accept", "application/xml");
            return message;
        }

        /// <summary> Restores a previously deleted Share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="deletedShareName"> Specifies the name of the previously-deleted share. </param>
        /// <param name="deletedShareVersion"> Specifies the version of the previously-deleted share. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ShareRestoreHeaders>> RestoreAsync(int? timeout = null, string deletedShareName = null, string deletedShareVersion = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateRestoreRequest(timeout, deletedShareName, deletedShareVersion);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new ShareRestoreHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Restores a previously deleted Share. </summary>
        /// <param name="timeout"> The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting Timeouts for File Service Operations.&lt;/a&gt;. </param>
        /// <param name="deletedShareName"> Specifies the name of the previously-deleted share. </param>
        /// <param name="deletedShareVersion"> Specifies the version of the previously-deleted share. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ShareRestoreHeaders> Restore(int? timeout = null, string deletedShareName = null, string deletedShareVersion = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateRestoreRequest(timeout, deletedShareName, deletedShareVersion);
            _pipeline.Send(message, cancellationToken);
            var headers = new ShareRestoreHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
