// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.Storage.Files.Shares
{
    internal partial class ShareDeleteHeaders
    {
        private readonly Response _response;
        public ShareDeleteHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicates the version of the File service used to execute the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> Returned only for provisioned v2 file shares. Returns an approximate used storage size of the share, in bytes. </summary>
        public long? XMsFileShareUsageBytes => _response.Headers.TryGetValue("x-ms-file-share-usage-bytes", out long? value) ? value : null;
        /// <summary> Returned only for provisioned v2 file shares. Returns an approximate used snapshot storage size of the share, in bytes. </summary>
        public long? XMsFileShareSnapshotUsageBytes => _response.Headers.TryGetValue("x-ms-file-share-snapshot-usage-bytes", out long? value) ? value : null;
    }
}
