// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Xml.Linq;

namespace Azure.Storage.Files.Shares.Models
{
    internal partial class StorageError
    {
        internal static StorageError DeserializeStorageError(XElement element)
        {
            string message = default;
            string authenticationErrorDetail = default;
            if (element.Element("Message") is XElement messageElement)
            {
                message = (string)messageElement;
            }
            if (element.Element("AuthenticationErrorDetail") is XElement authenticationErrorDetailElement)
            {
                authenticationErrorDetail = (string)authenticationErrorDetailElement;
            }
            return new StorageError(message, authenticationErrorDetail);
        }

        internal static StorageError DeserializeStorageError(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string message = default;
            string authenticationErrorDetail = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("Message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("AuthenticationErrorDetail"u8))
                {
                    authenticationErrorDetail = property.Value.GetString();
                    continue;
                }
            }
            return new StorageError(message, authenticationErrorDetail);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageError FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageError(document.RootElement);
        }
    }
}
