// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Storage.Files.Shares.Models
{
    /// <summary> The ShareTokenIntent. </summary>
    public readonly partial struct ShareTokenIntent : IEquatable<ShareTokenIntent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ShareTokenIntent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ShareTokenIntent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BackupValue = "backup";

        /// <summary> backup. </summary>
        public static ShareTokenIntent Backup { get; } = new ShareTokenIntent(BackupValue);
        /// <summary> Determines if two <see cref="ShareTokenIntent"/> values are the same. </summary>
        public static bool operator ==(ShareTokenIntent left, ShareTokenIntent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ShareTokenIntent"/> values are not the same. </summary>
        public static bool operator !=(ShareTokenIntent left, ShareTokenIntent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ShareTokenIntent"/>. </summary>
        public static implicit operator ShareTokenIntent(string value) => new ShareTokenIntent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ShareTokenIntent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ShareTokenIntent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
