// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Xml;
using System.Xml.Linq;
using Azure.Core;
using Azure.Storage.Common;

namespace Azure.Storage.Files.Shares.Models
{
    public partial class ShareSmbSettings : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "SMB");
            if (Common.Optional.IsDefined(Multichannel))
            {
                writer.WriteObjectValue(Multichannel, "Multichannel");
            }
            writer.WriteEndElement();
        }

        internal static ShareSmbSettings DeserializeShareSmbSettings(XElement element)
        {
            SmbMultichannel multichannel = default;
            if (element.Element("Multichannel") is XElement multichannelElement)
            {
                multichannel = SmbMultichannel.DeserializeSmbMultichannel(multichannelElement);
            }
            return new ShareSmbSettings(multichannel);
        }
    }
}
