// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Storage.Common;

namespace Azure.Storage.Files.Shares.Models
{
    /// <summary> Storage service properties. </summary>
    public partial class ShareServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="ShareServiceProperties"/>. </summary>
        /// <param name="hourMetrics"> A summary of request statistics grouped by API in hourly aggregates for files. </param>
        /// <param name="minuteMetrics"> A summary of request statistics grouped by API in minute aggregates for files. </param>
        /// <param name="cors"> The set of CORS rules. </param>
        /// <param name="protocol"> Protocol settings. </param>
        internal ShareServiceProperties(ShareMetrics hourMetrics, ShareMetrics minuteMetrics, IList<ShareCorsRule> cors, ShareProtocolSettings protocol)
        {
            HourMetrics = hourMetrics;
            MinuteMetrics = minuteMetrics;
            Cors = cors;
            Protocol = protocol;
        }

        /// <summary> A summary of request statistics grouped by API in hourly aggregates for files. </summary>
        public ShareMetrics HourMetrics { get; set; }
        /// <summary> A summary of request statistics grouped by API in minute aggregates for files. </summary>
        public ShareMetrics MinuteMetrics { get; set; }
        /// <summary> Protocol settings. </summary>
        public ShareProtocolSettings Protocol { get; set; }
    }
}
