// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Storage.Files.Shares.Models
{
    /// <summary> The retention policy. </summary>
    public partial class ShareRetentionPolicy
    {
        /// <summary> Initializes a new instance of <see cref="ShareRetentionPolicy"/>. </summary>
        /// <param name="enabled"> Indicates whether a retention policy is enabled for the File service. If false, metrics data is retained, and the user is responsible for deleting it. </param>
        /// <param name="days"> Indicates the number of days that metrics data should be retained. All data older than this value will be deleted. Metrics data is deleted on a best-effort basis after the retention period expires. </param>
        internal ShareRetentionPolicy(bool enabled, int? days)
        {
            Enabled = enabled;
            Days = days;
        }

        /// <summary> Indicates whether a retention policy is enabled for the File service. If false, metrics data is retained, and the user is responsible for deleting it. </summary>
        public bool Enabled { get; set; }
        /// <summary> Indicates the number of days that metrics data should be retained. All data older than this value will be deleted. Metrics data is deleted on a best-effort basis after the retention period expires. </summary>
        public int? Days { get; set; }
    }
}
