// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Storage.Common;

namespace Azure.Storage.Files.Shares.Models
{
    /// <summary> A permission (a security descriptor) at the share level. </summary>
    internal partial class SharePermission
    {
        /// <summary> Initializes a new instance of <see cref="SharePermission"/>. </summary>
        /// <param name="permission"> The permission in the Security Descriptor Definition Language (SDDL). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="permission"/> is null. </exception>
        public SharePermission(string permission)
        {
            Argument.AssertNotNull(permission, nameof(permission));

            Permission = permission;
        }

        /// <summary> Initializes a new instance of <see cref="SharePermission"/>. </summary>
        /// <param name="permission"> The permission in the Security Descriptor Definition Language (SDDL). </param>
        /// <param name="format"></param>
        internal SharePermission(string permission, FilePermissionFormat? format)
        {
            Permission = permission;
            Format = format;
        }

        /// <summary> The permission in the Security Descriptor Definition Language (SDDL). </summary>
        public string Permission { get; set; }
        /// <summary> Gets or sets the format. </summary>
        public FilePermissionFormat? Format { get; set; }
    }
}
