// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class ShareLeaseDurationExtensions
    {
        public static string ToSerialString(this ShareLeaseDuration value) => value switch
        {
            ShareLeaseDuration.Infinite => "infinite",
            ShareLeaseDuration.Fixed => "fixed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareLeaseDuration value.")
        };

        public static ShareLeaseDuration ToShareLeaseDuration(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "infinite")) return ShareLeaseDuration.Infinite;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "fixed")) return ShareLeaseDuration.Fixed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareLeaseDuration value.");
        }
    }
}
