// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml.Linq;

namespace Azure.Storage.Files.Shares.Models
{
    internal partial class ShareItemInternal
    {
        internal static ShareItemInternal DeserializeShareItemInternal(XElement element)
        {
            string name = default;
            string snapshot = default;
            bool? deleted = default;
            string version = default;
            SharePropertiesInternal properties = default;
            IReadOnlyDictionary<string, string> metadata = default;
            if (element.Element("Name") is XElement nameElement)
            {
                name = (string)nameElement;
            }
            if (element.Element("Snapshot") is XElement snapshotElement)
            {
                snapshot = (string)snapshotElement;
            }
            if (element.Element("Deleted") is XElement deletedElement)
            {
                deleted = (bool?)deletedElement;
            }
            if (element.Element("Version") is XElement versionElement)
            {
                version = (string)versionElement;
            }
            if (element.Element("Properties") is XElement propertiesElement)
            {
                properties = SharePropertiesInternal.DeserializeSharePropertiesInternal(propertiesElement);
            }
            if (element.Element("Metadata") is XElement metadataElement)
            {
                var dictionary = new Dictionary<string, string>();
                foreach (var e in metadataElement.Elements())
                {
                    dictionary.Add(e.Name.LocalName, (string)e);
                }
                metadata = dictionary;
            }
            return new ShareItemInternal(
                name,
                snapshot,
                deleted,
                version,
                properties,
                metadata);
        }
    }
}
