// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class ShareFileRangeWriteTypeExtensions
    {
        public static string ToSerialString(this ShareFileRangeWriteType value) => value switch
        {
            ShareFileRangeWriteType.Update => "update",
            ShareFileRangeWriteType.Clear => "clear",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareFileRangeWriteType value.")
        };

        public static ShareFileRangeWriteType ToShareFileRangeWriteType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "update")) return ShareFileRangeWriteType.Update;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "clear")) return ShareFileRangeWriteType.Clear;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareFileRangeWriteType value.");
        }
    }
}
