// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class PermissionCopyModeExtensions
    {
        public static string ToSerialString(this PermissionCopyMode value) => value switch
        {
            PermissionCopyMode.Source => "source",
            PermissionCopyMode.Override => "override",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PermissionCopyMode value.")
        };

        public static PermissionCopyMode ToPermissionCopyMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "source")) return PermissionCopyMode.Source;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "override")) return PermissionCopyMode.Override;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PermissionCopyMode value.");
        }
    }
}
