// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml.Linq;

namespace Azure.Storage.Files.Shares.Models
{
    internal partial class ListHandlesResponse
    {
        internal static ListHandlesResponse DeserializeListHandlesResponse(XElement element)
        {
            string nextMarker = default;
            IReadOnlyList<HandleItem> handleList = default;
            if (element.Element("NextMarker") is XElement nextMarkerElement)
            {
                nextMarker = (string)nextMarkerElement;
            }
            if (element.Element("Entries") is XElement entriesElement)
            {
                var array = new List<HandleItem>();
                foreach (var e in entriesElement.Elements("Handle"))
                {
                    array.Add(HandleItem.DeserializeHandleItem(e));
                }
                handleList = array;
            }
            return new ListHandlesResponse(handleList, nextMarker);
        }
    }
}
