// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class ListFilesIncludeTypeExtensions
    {
        public static string ToSerialString(this ListFilesIncludeType value) => value switch
        {
            ListFilesIncludeType.Timestamps => "Timestamps",
            ListFilesIncludeType.Etag => "Etag",
            ListFilesIncludeType.Attributes => "Attributes",
            ListFilesIncludeType.PermissionKey => "PermissionKey",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListFilesIncludeType value.")
        };

        public static ListFilesIncludeType ToListFilesIncludeType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Timestamps")) return ListFilesIncludeType.Timestamps;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Etag")) return ListFilesIncludeType.Etag;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Attributes")) return ListFilesIncludeType.Attributes;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PermissionKey")) return ListFilesIncludeType.PermissionKey;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListFilesIncludeType value.");
        }
    }
}
