// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class FilePermissionFormatExtensions
    {
        public static string ToSerialString(this FilePermissionFormat value) => value switch
        {
            FilePermissionFormat.Sddl => "Sddl",
            FilePermissionFormat.Binary => "Binary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilePermissionFormat value.")
        };

        public static FilePermissionFormat ToFilePermissionFormat(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Sddl")) return FilePermissionFormat.Sddl;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Binary")) return FilePermissionFormat.Binary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilePermissionFormat value.");
        }
    }
}
