// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class DeleteSnapshotsOptionTypeExtensions
    {
        public static string ToSerialString(this DeleteSnapshotsOptionType value) => value switch
        {
            DeleteSnapshotsOptionType.Include => "include",
            DeleteSnapshotsOptionType.IncludeLeased => "include-leased",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeleteSnapshotsOptionType value.")
        };

        public static DeleteSnapshotsOptionType ToDeleteSnapshotsOptionType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "include")) return DeleteSnapshotsOptionType.Include;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "include-leased")) return DeleteSnapshotsOptionType.IncludeLeased;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeleteSnapshotsOptionType value.");
        }
    }
}
