// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.Shares.Models
{
    internal static partial class AccessRightExtensions
    {
        public static string ToSerialString(this AccessRight value) => value switch
        {
            AccessRight.Read => "Read",
            AccessRight.Write => "Write",
            AccessRight.Delete => "Delete",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AccessRight value.")
        };

        public static AccessRight ToAccessRight(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Read")) return AccessRight.Read;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Write")) return AccessRight.Write;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Delete")) return AccessRight.Delete;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AccessRight value.");
        }
    }
}
