// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.Storage.Files.Shares
{
    internal partial class DirectoryGetPropertiesHeaders
    {
        private readonly Response _response;
        public DirectoryGetPropertiesHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> A set of name-value pairs that contain metadata for the directory. </summary>
        public IDictionary<string, string> Metadata => _response.Headers.TryGetValue("x-ms-meta-", out IDictionary<string, string> value) ? value : null;
        /// <summary> Returns the date and time the Directory was last modified. Operations on files within the directory do not affect the last modified time of the directory. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> Indicates the version of the File service used to execute the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> The value of this header is set to true if the directory metadata is completely encrypted using the specified algorithm. Otherwise, the value is set to false. </summary>
        public bool? IsServerEncrypted => _response.Headers.TryGetValue("x-ms-server-encrypted", out bool? value) ? value : null;
        /// <summary> Attributes set for the directory. </summary>
        public string FileAttributes => _response.Headers.TryGetValue("x-ms-file-attributes", out string value) ? value : null;
        /// <summary> Creation time for the directory. </summary>
        public DateTimeOffset? FileCreationTime => _response.Headers.TryGetValue("x-ms-file-creation-time", out DateTimeOffset? value) ? value : null;
        /// <summary> Last write time for the directory. </summary>
        public DateTimeOffset? FileLastWriteTime => _response.Headers.TryGetValue("x-ms-file-last-write-time", out DateTimeOffset? value) ? value : null;
        /// <summary> Change time for the directory. </summary>
        public DateTimeOffset? FileChangeTime => _response.Headers.TryGetValue("x-ms-file-change-time", out DateTimeOffset? value) ? value : null;
        /// <summary> Key of the permission set for the directory. </summary>
        public string FilePermissionKey => _response.Headers.TryGetValue("x-ms-file-permission-key", out string value) ? value : null;
        /// <summary> The fileId of the directory. </summary>
        public string FileId => _response.Headers.TryGetValue("x-ms-file-id", out string value) ? value : null;
        /// <summary> The parent fileId of the directory. </summary>
        public string FileParentId => _response.Headers.TryGetValue("x-ms-file-parent-id", out string value) ? value : null;
    }
}
