// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.Storage.Files.Shares
{
    internal partial class DirectoryForceCloseHandlesHeaders
    {
        private readonly Response _response;
        public DirectoryForceCloseHandlesHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicates the version of the File service used to execute the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> A string describing next handle to be closed. It is returned when more handles need to be closed to complete the request. </summary>
        public string Marker => _response.Headers.TryGetValue("x-ms-marker", out string value) ? value : null;
        /// <summary> Contains count of number of handles closed. </summary>
        public int? NumberOfHandlesClosed => _response.Headers.TryGetValue("x-ms-number-of-handles-closed", out int? value) ? value : null;
        /// <summary> Contains count of number of handles that failed to close. </summary>
        public int? NumberOfHandlesFailedToClose => _response.Headers.TryGetValue("x-ms-number-of-handles-failed", out int? value) ? value : null;
    }
}
