// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Storage.Files.DataLake
{
    internal partial class PathReadHeaders
    {
        private readonly Response _response;
        public PathReadHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicates that the service supports requests for partial file content. </summary>
        public string AcceptRanges => _response.Headers.TryGetValue("Accept-Ranges", out string value) ? value : null;
        /// <summary> If the Cache-Control request header has previously been set for the resource, that value is returned in this header. </summary>
        public string CacheControl => _response.Headers.TryGetValue("Cache-Control", out string value) ? value : null;
        /// <summary> If the Content-Disposition request header has previously been set for the resource, that value is returned in this header. </summary>
        public string ContentDisposition => _response.Headers.TryGetValue("Content-Disposition", out string value) ? value : null;
        /// <summary> If the Content-Encoding request header has previously been set for the resource, that value is returned in this header. </summary>
        public string ContentEncoding => _response.Headers.TryGetValue("Content-Encoding", out string value) ? value : null;
        /// <summary> If the Content-Language request header has previously been set for the resource, that value is returned in this header. </summary>
        public string ContentLanguage => _response.Headers.TryGetValue("Content-Language", out string value) ? value : null;
        /// <summary> The size of the resource in bytes. </summary>
        public long? ContentLength => _response.Headers.TryGetValue("Content-Length", out long? value) ? value : null;
        /// <summary> Indicates the range of bytes returned in the event that the client requested a subset of the file by setting the Range request header. </summary>
        public string ContentRange => _response.Headers.TryGetValue("Content-Range", out string value) ? value : null;
        /// <summary> The content type specified for the resource. If no content type was specified, the default content type is application/octet-stream. </summary>
        public string ContentType => _response.Headers.TryGetValue("Content-Type", out string value) ? value : null;
        /// <summary> The MD5 hash of complete file. If the file has an MD5 hash and this read operation is to read the complete file, this response header is returned so that the client can check for message content integrity. </summary>
        public string ContentMD5 => _response.Headers.TryGetValue("Content-MD5", out string value) ? value : null;
        /// <summary> The data and time the file or directory was last modified.  Write operations on the file or directory update the last modified time. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> The version of the REST protocol used to process the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> The type of the resource.  The value may be "file" or "directory".  If not set, the value is "file". </summary>
        public string ResourceType => _response.Headers.TryGetValue("x-ms-resource-type", out string value) ? value : null;
        /// <summary> The user-defined properties associated with the file or directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...", where each value is a base64 encoded string. Note that the string may only contain ASCII characters in the ISO-8859-1 character set. </summary>
        public string Properties => _response.Headers.TryGetValue("x-ms-properties", out string value) ? value : null;
        /// <summary> When a resource is leased, specifies whether the lease is of infinite or fixed duration. </summary>
        public string LeaseDuration => _response.Headers.TryGetValue("x-ms-lease-duration", out string value) ? value : null;
        /// <summary> Lease state of the resource. </summary>
        public string LeaseState => _response.Headers.TryGetValue("x-ms-lease-state", out string value) ? value : null;
        /// <summary> The lease status of the resource. </summary>
        public string LeaseStatus => _response.Headers.TryGetValue("x-ms-lease-status", out string value) ? value : null;
        /// <summary> The value of this header is set to true if the contents of the request are successfully encrypted using the specified algorithm, and false otherwise. </summary>
        public bool? IsServerEncrypted => _response.Headers.TryGetValue("x-ms-request-server-encrypted", out bool? value) ? value : null;
        /// <summary> The SHA-256 hash of the encryption key used to encrypt the blob. This header is only returned when the blob was encrypted with a customer-provided key. </summary>
        public string EncryptionKeySha256 => _response.Headers.TryGetValue("x-ms-encryption-key-sha256", out string value) ? value : null;
        /// <summary> The MD5 hash of complete file stored in storage. If the file has a MD5 hash, and if request contains range header (Range or x-ms-range), this response header is returned with the value of the complete file's MD5 value. This value may or may not be equal to the value returned in Content-MD5 header, with the latter calculated from the requested range. </summary>
        public string XMsContentMd5 => _response.Headers.TryGetValue("x-ms-content-md5", out string value) ? value : null;
    }
}
