// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Storage.Files.DataLake
{
    internal partial class PathLeaseHeaders
    {
        private readonly Response _response;
        public PathLeaseHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> The data and time the file was last modified.  Write operations on the file update the last modified time. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> The version of the REST protocol used to process the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> A successful "renew" action returns the lease ID. </summary>
        public string LeaseId => _response.Headers.TryGetValue("x-ms-lease-id", out string value) ? value : null;
        /// <summary> The time remaining in the lease period in seconds. </summary>
        public string LeaseTime => _response.Headers.TryGetValue("x-ms-lease-time", out string value) ? value : null;
    }
}
