// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Storage.Common;

namespace Azure.Storage.Files.DataLake.Models
{
    internal partial class SetAccessControlRecursiveResponse
    {
        internal static SetAccessControlRecursiveResponse DeserializeSetAccessControlRecursiveResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? directoriesSuccessful = default;
            int? filesSuccessful = default;
            int? failureCount = default;
            IReadOnlyList<AclFailedEntry> failedEntries = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("directoriesSuccessful"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    directoriesSuccessful = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("filesSuccessful"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    filesSuccessful = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("failureCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failureCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("failedEntries"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AclFailedEntry> array = new List<AclFailedEntry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AclFailedEntry.DeserializeAclFailedEntry(item));
                    }
                    failedEntries = array;
                    continue;
                }
            }
            return new SetAccessControlRecursiveResponse(directoriesSuccessful, filesSuccessful, failureCount, failedEntries ?? new ChangeTrackingList<AclFailedEntry>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SetAccessControlRecursiveResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSetAccessControlRecursiveResponse(document.RootElement);
        }
    }
}
