// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.DataLake.Models
{
    internal static partial class PathUpdateActionExtensions
    {
        public static string ToSerialString(this PathUpdateAction value) => value switch
        {
            PathUpdateAction.Append => "append",
            PathUpdateAction.Flush => "flush",
            PathUpdateAction.SetProperties => "setProperties",
            PathUpdateAction.SetAccessControl => "setAccessControl",
            PathUpdateAction.SetAccessControlRecursive => "setAccessControlRecursive",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PathUpdateAction value.")
        };

        public static PathUpdateAction ToPathUpdateAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "append")) return PathUpdateAction.Append;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "flush")) return PathUpdateAction.Flush;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "setProperties")) return PathUpdateAction.SetProperties;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "setAccessControl")) return PathUpdateAction.SetAccessControl;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "setAccessControlRecursive")) return PathUpdateAction.SetAccessControlRecursive;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PathUpdateAction value.");
        }
    }
}
