// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.DataLake.Models
{
    internal static partial class PathLeaseActionExtensions
    {
        public static string ToSerialString(this PathLeaseAction value) => value switch
        {
            PathLeaseAction.Acquire => "acquire",
            PathLeaseAction.Break => "break",
            PathLeaseAction.Change => "change",
            PathLeaseAction.Renew => "renew",
            PathLeaseAction.Release => "release",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PathLeaseAction value.")
        };

        public static PathLeaseAction ToPathLeaseAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "acquire")) return PathLeaseAction.Acquire;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "break")) return PathLeaseAction.Break;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "change")) return PathLeaseAction.Change;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "renew")) return PathLeaseAction.Renew;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "release")) return PathLeaseAction.Release;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PathLeaseAction value.");
        }
    }
}
