// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Storage.Files.DataLake.Models
{
    /// <summary> The PathExpiryOptions. </summary>
    internal readonly partial struct PathExpiryOptions : IEquatable<PathExpiryOptions>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PathExpiryOptions"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PathExpiryOptions(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NeverExpireValue = "NeverExpire";
        private const string RelativeToCreationValue = "RelativeToCreation";
        private const string RelativeToNowValue = "RelativeToNow";
        private const string AbsoluteValue = "Absolute";

        /// <summary> NeverExpire. </summary>
        public static PathExpiryOptions NeverExpire { get; } = new PathExpiryOptions(NeverExpireValue);
        /// <summary> RelativeToCreation. </summary>
        public static PathExpiryOptions RelativeToCreation { get; } = new PathExpiryOptions(RelativeToCreationValue);
        /// <summary> RelativeToNow. </summary>
        public static PathExpiryOptions RelativeToNow { get; } = new PathExpiryOptions(RelativeToNowValue);
        /// <summary> Absolute. </summary>
        public static PathExpiryOptions Absolute { get; } = new PathExpiryOptions(AbsoluteValue);
        /// <summary> Determines if two <see cref="PathExpiryOptions"/> values are the same. </summary>
        public static bool operator ==(PathExpiryOptions left, PathExpiryOptions right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PathExpiryOptions"/> values are not the same. </summary>
        public static bool operator !=(PathExpiryOptions left, PathExpiryOptions right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PathExpiryOptions"/>. </summary>
        public static implicit operator PathExpiryOptions(string value) => new PathExpiryOptions(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PathExpiryOptions other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PathExpiryOptions other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
