// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.DataLake.Models
{
    internal static partial class ListBlobsIncludeItemExtensions
    {
        public static string ToSerialString(this ListBlobsIncludeItem value) => value switch
        {
            ListBlobsIncludeItem.Copy => "copy",
            ListBlobsIncludeItem.Deleted => "deleted",
            ListBlobsIncludeItem.Metadata => "metadata",
            ListBlobsIncludeItem.Snapshots => "snapshots",
            ListBlobsIncludeItem.Uncommittedblobs => "uncommittedblobs",
            ListBlobsIncludeItem.Versions => "versions",
            ListBlobsIncludeItem.Tags => "tags",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListBlobsIncludeItem value.")
        };

        public static ListBlobsIncludeItem ToListBlobsIncludeItem(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "copy")) return ListBlobsIncludeItem.Copy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "deleted")) return ListBlobsIncludeItem.Deleted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "metadata")) return ListBlobsIncludeItem.Metadata;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "snapshots")) return ListBlobsIncludeItem.Snapshots;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "uncommittedblobs")) return ListBlobsIncludeItem.Uncommittedblobs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "versions")) return ListBlobsIncludeItem.Versions;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "tags")) return ListBlobsIncludeItem.Tags;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListBlobsIncludeItem value.");
        }
    }
}
