// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Storage.Common;

namespace Azure.Storage.Files.DataLake.Models
{
    internal partial class FileSystemList
    {
        internal static FileSystemList DeserializeFileSystemList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<FileSystem> filesystems = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("filesystems"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FileSystem> array = new List<FileSystem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FileSystem.DeserializeFileSystem(item));
                    }
                    filesystems = array;
                    continue;
                }
            }
            return new FileSystemList(filesystems ?? new ChangeTrackingList<FileSystem>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FileSystemList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFileSystemList(document.RootElement);
        }
    }
}
