// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Files.DataLake.Models
{
    internal static partial class DataLakeLeaseActionExtensions
    {
        public static string ToSerialString(this DataLakeLeaseAction value) => value switch
        {
            DataLakeLeaseAction.Acquire => "acquire",
            DataLakeLeaseAction.AutoRenew => "auto-renew",
            DataLakeLeaseAction.Release => "release",
            DataLakeLeaseAction.AcquireRelease => "acquire-release",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeLeaseAction value.")
        };

        public static DataLakeLeaseAction ToDataLakeLeaseAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "acquire")) return DataLakeLeaseAction.Acquire;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "auto-renew")) return DataLakeLeaseAction.AutoRenew;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "release")) return DataLakeLeaseAction.Release;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "acquire-release")) return DataLakeLeaseAction.AcquireRelease;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeLeaseAction value.");
        }
    }
}
