// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Storage.Files.DataLake
{
    internal partial class FileSystemListPathsHeaders
    {
        private readonly Response _response;
        public FileSystemListPathsHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> The data and time the filesystem was last modified.  Changes to filesystem properties update the last modified time, but operations on files and directories do not. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> The version of the REST protocol used to process the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> If the number of paths to be listed exceeds the maxResults limit, a continuation token is returned in this response header.  When a continuation token is returned in the response, it must be specified in a subsequent invocation of the list operation to continue listing the paths. </summary>
        public string Continuation => _response.Headers.TryGetValue("x-ms-continuation", out string value) ? value : null;
    }
}
