// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Storage.Files.DataLake
{
    internal partial class FileSystemCreateHeaders
    {
        private readonly Response _response;
        public FileSystemCreateHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> The data and time the filesystem was last modified.  Operations on files and directories do not affect the last modified time. </summary>
        public DateTimeOffset? LastModified => _response.Headers.TryGetValue("Last-Modified", out DateTimeOffset? value) ? value : null;
        /// <summary> The version of the REST protocol used to process the request. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> A bool string indicates whether the namespace feature is enabled. If "true", the namespace is enabled for the filesystem. </summary>
        public string NamespaceEnabled => _response.Headers.TryGetValue("x-ms-namespace-enabled", out string value) ? value : null;
    }
}
