// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class SkuNameExtensions
    {
        public static string ToSerialString(this SkuName value) => value switch
        {
            SkuName.StandardLrs => "Standard_LRS",
            SkuName.StandardGrs => "Standard_GRS",
            SkuName.StandardRagrs => "Standard_RAGRS",
            SkuName.StandardZrs => "Standard_ZRS",
            SkuName.PremiumLrs => "Premium_LRS",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SkuName value.")
        };

        public static SkuName ToSkuName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard_LRS")) return SkuName.StandardLrs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard_GRS")) return SkuName.StandardGrs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard_RAGRS")) return SkuName.StandardRagrs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard_ZRS")) return SkuName.StandardZrs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium_LRS")) return SkuName.PremiumLrs;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SkuName value.");
        }
    }
}
