// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class SequenceNumberActionExtensions
    {
        public static string ToSerialString(this SequenceNumberAction value) => value switch
        {
            SequenceNumberAction.Max => "max",
            SequenceNumberAction.Update => "update",
            SequenceNumberAction.Increment => "increment",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SequenceNumberAction value.")
        };

        public static SequenceNumberAction ToSequenceNumberAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "max")) return SequenceNumberAction.Max;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "update")) return SequenceNumberAction.Update;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "increment")) return SequenceNumberAction.Increment;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SequenceNumberAction value.");
        }
    }
}
