// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class QueryFormatTypeExtensions
    {
        public static string ToSerialString(this QueryFormatType value) => value switch
        {
            QueryFormatType.Delimited => "delimited",
            QueryFormatType.Json => "json",
            QueryFormatType.Arrow => "arrow",
            QueryFormatType.Parquet => "parquet",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueryFormatType value.")
        };

        public static QueryFormatType ToQueryFormatType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "delimited")) return QueryFormatType.Delimited;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "json")) return QueryFormatType.Json;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "arrow")) return QueryFormatType.Arrow;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "parquet")) return QueryFormatType.Parquet;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QueryFormatType value.");
        }
    }
}
