// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class PublicAccessTypeExtensions
    {
        public static string ToSerialString(this PublicAccessType value) => value switch
        {
            PublicAccessType.BlobContainer => "container",
            PublicAccessType.Blob => "blob",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PublicAccessType value.")
        };

        public static PublicAccessType ToPublicAccessType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "container")) return PublicAccessType.BlobContainer;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "blob")) return PublicAccessType.Blob;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PublicAccessType value.");
        }
    }
}
