// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml.Linq;

namespace Azure.Storage.Blobs.Models
{
    internal partial class PageList
    {
        internal static PageList DeserializePageList(XElement element)
        {
            string nextMarker = default;
            IReadOnlyList<PageRange> pageRange = default;
            IReadOnlyList<ClearRange> clearRange = default;
            if (element.Element("NextMarker") is XElement nextMarkerElement)
            {
                nextMarker = (string)nextMarkerElement;
            }
            var array = new List<PageRange>();
            foreach (var e in element.Elements("PageRange"))
            {
                array.Add(Models.PageRange.DeserializePageRange(e));
            }
            pageRange = array;
            var array0 = new List<ClearRange>();
            foreach (var e in element.Elements("ClearRange"))
            {
                array0.Add(Models.ClearRange.DeserializeClearRange(e));
            }
            clearRange = array0;
            return new PageList(pageRange, clearRange, nextMarker);
        }
    }
}
