// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml.Linq;

namespace Azure.Storage.Blobs.Models
{
    internal partial class ListContainersSegmentResponse
    {
        internal static ListContainersSegmentResponse DeserializeListContainersSegmentResponse(XElement element)
        {
            string serviceEndpoint = default;
            string prefix = default;
            string marker = default;
            int? maxResults = default;
            string nextMarker = default;
            IReadOnlyList<ContainerItemInternal> containerItems = default;
            if (element.Attribute("ServiceEndpoint") is XAttribute serviceEndpointAttribute)
            {
                serviceEndpoint = (string)serviceEndpointAttribute;
            }
            if (element.Element("Prefix") is XElement prefixElement)
            {
                prefix = (string)prefixElement;
            }
            if (element.Element("Marker") is XElement markerElement)
            {
                marker = (string)markerElement;
            }
            if (element.Element("MaxResults") is XElement maxResultsElement)
            {
                maxResults = (int?)maxResultsElement;
            }
            if (element.Element("NextMarker") is XElement nextMarkerElement)
            {
                nextMarker = (string)nextMarkerElement;
            }
            if (element.Element("Containers") is XElement containersElement)
            {
                var array = new List<ContainerItemInternal>();
                foreach (var e in containersElement.Elements("Container"))
                {
                    array.Add(ContainerItemInternal.DeserializeContainerItemInternal(e));
                }
                containerItems = array;
            }
            return new ListContainersSegmentResponse(
                serviceEndpoint,
                prefix,
                marker,
                maxResults,
                containerItems,
                nextMarker);
        }
    }
}
