// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class ListContainersIncludeTypeExtensions
    {
        public static string ToSerialString(this ListContainersIncludeType value) => value switch
        {
            ListContainersIncludeType.Metadata => "metadata",
            ListContainersIncludeType.Deleted => "deleted",
            ListContainersIncludeType.System => "system",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListContainersIncludeType value.")
        };

        public static ListContainersIncludeType ToListContainersIncludeType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "metadata")) return ListContainersIncludeType.Metadata;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "deleted")) return ListContainersIncludeType.Deleted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "system")) return ListContainersIncludeType.System;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ListContainersIncludeType value.");
        }
    }
}
