// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Xml.Linq;

namespace Azure.Storage.Blobs.Models
{
    internal partial class ListBlobsFlatSegmentResponse
    {
        internal static ListBlobsFlatSegmentResponse DeserializeListBlobsFlatSegmentResponse(XElement element)
        {
            string serviceEndpoint = default;
            string containerName = default;
            string prefix = default;
            string marker = default;
            int? maxResults = default;
            BlobFlatListSegment segment = default;
            string nextMarker = default;
            if (element.Attribute("ServiceEndpoint") is XAttribute serviceEndpointAttribute)
            {
                serviceEndpoint = (string)serviceEndpointAttribute;
            }
            if (element.Attribute("ContainerName") is XAttribute containerNameAttribute)
            {
                containerName = (string)containerNameAttribute;
            }
            if (element.Element("Prefix") is XElement prefixElement)
            {
                prefix = (string)prefixElement;
            }
            if (element.Element("Marker") is XElement markerElement)
            {
                marker = (string)markerElement;
            }
            if (element.Element("MaxResults") is XElement maxResultsElement)
            {
                maxResults = (int?)maxResultsElement;
            }
            if (element.Element("Blobs") is XElement blobsElement)
            {
                segment = BlobFlatListSegment.DeserializeBlobFlatListSegment(blobsElement);
            }
            if (element.Element("NextMarker") is XElement nextMarkerElement)
            {
                nextMarker = (string)nextMarkerElement;
            }
            return new ListBlobsFlatSegmentResponse(
                serviceEndpoint,
                containerName,
                prefix,
                marker,
                maxResults,
                segment,
                nextMarker);
        }
    }
}
