// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class LeaseStatusExtensions
    {
        public static string ToSerialString(this LeaseStatus value) => value switch
        {
            LeaseStatus.Locked => "locked",
            LeaseStatus.Unlocked => "unlocked",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseStatus value.")
        };

        public static LeaseStatus ToLeaseStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "locked")) return LeaseStatus.Locked;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "unlocked")) return LeaseStatus.Unlocked;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseStatus value.");
        }
    }
}
