// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class LeaseStateExtensions
    {
        public static string ToSerialString(this LeaseState value) => value switch
        {
            LeaseState.Available => "available",
            LeaseState.Leased => "leased",
            LeaseState.Expired => "expired",
            LeaseState.Breaking => "breaking",
            LeaseState.Broken => "broken",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseState value.")
        };

        public static LeaseState ToLeaseState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "available")) return LeaseState.Available;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "leased")) return LeaseState.Leased;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "expired")) return LeaseState.Expired;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "breaking")) return LeaseState.Breaking;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "broken")) return LeaseState.Broken;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseState value.");
        }
    }
}
