// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class LeaseDurationTypeExtensions
    {
        public static string ToSerialString(this LeaseDurationType value) => value switch
        {
            LeaseDurationType.Infinite => "infinite",
            LeaseDurationType.Fixed => "fixed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseDurationType value.")
        };

        public static LeaseDurationType ToLeaseDurationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "infinite")) return LeaseDurationType.Infinite;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "fixed")) return LeaseDurationType.Fixed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LeaseDurationType value.");
        }
    }
}
