// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class FilterBlobsIncludeItemExtensions
    {
        public static string ToSerialString(this FilterBlobsIncludeItem value) => value switch
        {
            FilterBlobsIncludeItem.None => "none",
            FilterBlobsIncludeItem.Versions => "versions",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilterBlobsIncludeItem value.")
        };

        public static FilterBlobsIncludeItem ToFilterBlobsIncludeItem(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "none")) return FilterBlobsIncludeItem.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "versions")) return FilterBlobsIncludeItem.Versions;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilterBlobsIncludeItem value.");
        }
    }
}
