// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class EncryptionAlgorithmTypeInternalExtensions
    {
        public static string ToSerialString(this EncryptionAlgorithmTypeInternal value) => value switch
        {
            EncryptionAlgorithmTypeInternal.None => "None",
            EncryptionAlgorithmTypeInternal.AES256 => "AES256",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EncryptionAlgorithmTypeInternal value.")
        };

        public static EncryptionAlgorithmTypeInternal ToEncryptionAlgorithmTypeInternal(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return EncryptionAlgorithmTypeInternal.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AES256")) return EncryptionAlgorithmTypeInternal.AES256;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EncryptionAlgorithmTypeInternal value.");
        }
    }
}
