// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class DeleteSnapshotsOptionExtensions
    {
        public static string ToSerialString(this DeleteSnapshotsOption value) => value switch
        {
            DeleteSnapshotsOption.IncludeSnapshots => "include",
            DeleteSnapshotsOption.OnlySnapshots => "only",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeleteSnapshotsOption value.")
        };

        public static DeleteSnapshotsOption ToDeleteSnapshotsOption(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "include")) return DeleteSnapshotsOption.IncludeSnapshots;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "only")) return DeleteSnapshotsOption.OnlySnapshots;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeleteSnapshotsOption value.");
        }
    }
}
