// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Storage.Blobs.Models
{
    internal static partial class CopyStatusExtensions
    {
        public static string ToSerialString(this CopyStatus value) => value switch
        {
            CopyStatus.Pending => "pending",
            CopyStatus.Success => "success",
            CopyStatus.Aborted => "aborted",
            CopyStatus.Failed => "failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CopyStatus value.")
        };

        public static CopyStatus ToCopyStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "pending")) return CopyStatus.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "success")) return CopyStatus.Success;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "aborted")) return CopyStatus.Aborted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "failed")) return CopyStatus.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CopyStatus value.");
        }
    }
}
